package cn.com.duiba.supplier.channel.service.api.dto.response.bankmoretransfer;

import cn.com.duiba.supplier.channel.service.api.enums.channel.ShenbianyunCodeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zzy
 * @create 2024/03/19 20:04
 **/
@Data
public class ShenbyBankMoreTransferResp implements Serializable {


    private static final long serialVersionUID = 3747120028657299330L;

    /**
     * 商户订单号
     */
    private String merOrderId;

    /**
     * 平台订单号，全局唯一。
     */
    private Long orderNo;

    /**
     * 付款金额（分）
     */
    private Long amt;

    /**
     * 付款金额（分）
     */
    private Long fee;

    /**
     * 交易状态：1: 付款中3：成功 4：失败
     */
    private Long state;

    /**
     * 响应码（订单请求信息的受理状态，非下发订单的交易状态）
     */
    private String resCode;
    /**
     * 响应信息
     */
    private String resMsg;

    public boolean isSuccess() {
        return ShenbianyunCodeEnum.S0000.getCode().equals(resCode);
    }
}
