package cn.com.duiba.supplier.channel.service.api.dto.response.wx.redpacket;

import cn.com.duiba.supplier.channel.service.api.enums.channel.JigaoWxRedPacketRcvStatus;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;

/**
 * 继皋微信红包回调解析结果
 *
 * @author wangguanhua
 */
@NoArgsConstructor
@ToString(callSuper = true)
@Data
public class JiGaoWxRedPacketNotifyResp implements Serializable {

    private static final long serialVersionUID = -3566132753203514471L;

    /**
     * 商户订单号，最大32位，需要保证唯一
     * 选填
     */
    private String orderNo;

    /**
     * 微信流水号
     */
    private String detailId;

    /**
     * 领取状态
     *
     * @see JigaoWxRedPacketRcvStatus#name()
     */
    private String status;

    /**
     * 红包发送时间
     */
    private String sendTime;

    /**
     * 失败原因
     */
    private String reason;

    /**
     * 用户openid
     */
    private String openid;

    /**
     * 红包领取时间
     */
    private String rcvTime;

    /**
     * 下单订单号（内部）
     */
    private String bizOrderNo;

}
