package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

/**
 * 荣数账号类型
 *
 * @author wangguanhua
 */
@RequiredArgsConstructor
@Getter
public enum RongshuAccTypeEnum {

    /**
     * 手机号（券码类商品需校验手机号时必填）
     */
    PHONE_NUMBER("0", "手机号"),

    /**
     * QQ号
     */
    QQ_NUMBER("1", "QQ号"),

    /**
     * 邮箱
     */
    EMAIL("2", "邮箱"),

    /**
     * 航空公司会员号
     */
    AIRLINE_MEMBERSHIP("3", "航空公司会员号"),

    /**
     * 游戏账号
     */
    GAME_ACCOUNT("4", "游戏账号"),

    /**
     * 微信OpenID
     */
    WECHAT_OPENID("5", "微信OpenID"),

    /**
     * 支付宝OpenID
     */
    ALIPAY_OPENID("6", "支付宝OpenID"),

    /**
     * 加油卡号
     */
    FUEL_CARD_NUMBER("7", "加油卡号"),

    /**
     * 特殊类型，仅虚拟
     */
    SPECIAL_TYPE_VIRTUAL_ONLY("8", "特殊类型，仅虚拟");

    private final String code;
    private final String description;
}
