package cn.com.duiba.supplier.channel.service.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author lizhi
 * @date 2023/12/27 17:53
 */
@Getter
@AllArgsConstructor
public enum BaWangChangeTypeEnum {

    VERIFICATION(2, "已使用"),
    REFUND(3, "冲正"),
    AUTO_EXPIRE(7, "回收"),
    ;
    private final Integer code;

    private final String desc;
    
    private static final Map<Integer, BaWangChangeTypeEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(BaWangChangeTypeEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    
    /**
     * 根据枚举名称获取枚举
     * @param code 枚举名称
     * @return 枚举
     */
    public static BaWangChangeTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
