package cn.com.duiba.supplier.channel.service.api.dto.request.iqiyi;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 爱奇艺直充
 * @author lizhi
 * @date 2023/4/17 1:36 PM
 */
@Data
public class IQiYiZcReq implements Serializable {
    
    private static final long serialVersionUID = -4429821352256408204L;

    /**
     * 产品编码	
     * 产品编码，由爱奇艺提供
     */
    @NotBlank(message = "item不能为空")
    private String item;

    /**
     * 数量	 
     * 购买产品数量
     */
    @NotNull(message = "amount不能为空")
    private Integer amount;

    /**
     * 金额 (整数)
     * 订单总金额=（合作方侧商品售卖单价*amount），单位为“分”。爱奇艺侧会根据这个金额以及双方合同约定的结算方式和分成比例等，计算出结算价，用于双方最终结算。
     */
    @NotNull(message = "sum不能为空")
    private Long sum;

    /**
     * 用户手机号, 3选1
     * 手机号，未注册的爱奇艺会自动注册，并下发短信通知用户账号信息
     */
    private String mobile;

    /**
     * 加密的手机号, 3选1
     * 加密格式的手机号（其他同上），采用RSA加密，加密方法见RSA加密，密钥由爱奇艺提供
     */
    private String encryptedMobile;

    /**
     * 合作方用户id, 3选1
     * 对于无法传手机号的合作方，在与爱奇艺passport完成对接后，可传此字段。如果同时传入mobile/ encryptedMobile字段，优先取此字段。
     */
    private String partnerUserId;
}
