package cn.com.duiba.supplier.channel.service.api.dto.response.carser;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class CarEasyQueryMchResp implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 商家名称
     */
    private String name;

    /**
     * 省份编码
     */
    private String provinceCode;

    /**
     * 省份名称
     */
    private String provinceName;

    /**
     * 城市编码
     */
    private String cityCode;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 区县名称
     */
    private String regionName;

    /**
     * 区县编码
     */
    private String regionCode;

    /**
     * 维度
     */
    private String latitude;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 联系人
     */
    private String linkMan;

    /**
     * 联系电话
     */
    private String linkPhone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 店铺图片(大图)
     */
    private String imageUrl;

    /**
     * 店铺图片(小图)
     */
    private String smallImageUrl;

    /**
     * 店铺详细地址
     */
    private String address;

    /**
     * 店铺营业开始时间,
     */
    private String openTime;

    /**
     * 店铺营业结束时间,
     */
    private String closeTime;

    /**
     * 仅当传经纬度过来时，返回门店直线距离
     */
    private String distance;

    /**
     * 店铺能做的项目的车妈妈平台的code码合集
     */
    private String goodeCodeFull;

    /**
     * 支持的服务类型
     */
    private List<String> serviceIds;

    /**
     * 店铺id
     */
    private String shopId;

    /**
     * 下页是否有数据
     */
    private Boolean nextFlag;
}
