package cn.com.duiba.supplier.channel.service.api.dto.response.meituancoupon;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class MeiTuanPayCouponResp implements Serializable {

    /**
     * 是否成功
     *  success / fail，不区分大小写
     *  fail：errorCode为100001或100005时，发券结果未知，可用原流水号重试；为其他值时，发券失败
     */
    private String status;

    /**
     * 错误码
     * status="fail"时返回
     * 100001 / 100005，可用原流水号重试
     */
    private Integer errorCode;

    /**
     * 错误信息
     *  status="fail"时返回
     */
    private String errorMsg;

    /**
     * 发券结果详情 (status="success"时返回)
     */
    private List<CouponInfoDto> data;

}
