package cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor;

import lombok.Data;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author zzy
 * @create 2025/06/24 19:56
 **/
@Data
public class WxFavorQueryBankMultiActivityCouponDetailDto implements Serializable {
    private static final long serialVersionUID = 5130431702723809349L;
    /**
     * stock_creator_mchid 　必填 string
     * <p>
     * 【创建批次的商户号】 微信为创建方商户分配的商户号
     */
    private String stockCreatorMchid;

    /**
     * stock_id 　必填 string
     * <p>
     * 【批次ID】 微信为每个代金券批次分配的唯一ID。
     */
    private String stockId;

    /**
     * coupon_id 　必填 string
     * <p>
     * 【代金券ID】 微信为代金券唯一分配的ID
     */
    private String couponId;

    /**
     * coupon_name 　必填 string
     * <p>
     * 【券名称】 券名称
     */
    private String couponName;

    /**
     * coupon_state 　必填 string
     * 【券状态】 券状态
     * 可选取值:
     * COUPON_STATE_UNKNOW: 未知状态
     * COUPON_STATE_SEND: 可用
     * COUPON_STATE_USED: 已实扣
     * COUPON_STATE_EXPIRED: 已过期
     */
    private String couponState;

    /**
     * receive_time 　必填 string
     * <p>
     * 【领券时间】 领券时间
     */
    private Date receiveTime;

    /**
     * available_begin_time 　必填 string
     * <p>
     * 【可用开始时间】 可用开始时间
     */
    private Date availableBeginTime;

    /**
     * available_end_time 　必填 string
     * <p>
     * 【可用结束时间】 可用结束时间
     */
    private Date availableEndTime;

    /**
     * activity_id 　必填 string
     * <p>
     * 【活动ID】 多笔立减活动ID
     */
    private String activityId;

    /**
     * max_use_number 　必填 integer
     * <p>
     * 【最大使用次数】 券的最大使用次数
     */
    private Integer maxUseNumber;

    /**
     * available_number 　必填 integer
     * <p>
     * 【可用次数】 券的剩余可用次数
     */
    private Integer availableNumber;

    /**
     * used_number 　必填 integer
     * <p>
     * 【已使用次数】 券的已使用次数
     */
    private Integer usedNumber;

    /**
     * use_amount_list 　选填 object
     * <p>
     * 【已用金额列表】 券的已使用金额列表，列表中的元素代表该次使用的金额
     */
    private UseAmountList useAmountList;

    /**
     * openid 　选填 string
     * <p>
     * 【用户标识ID】 用户标识ID是微信用户在公众账号ID下的唯一用户标识（公众账号ID不同，则获取到的用户标识ID就不同），可用于永久标记一个用户。
     */
    private String openId;

    /**
     * http状态码, 200为成功
     */
    private Integer httpCode;

    /**
     * 错误码
     */
    private String code;

    /**
     * 描述
     */
    private String message;

    /**
     * 失败原因
     */
    private String errorMsg;


    @Data
    public static class UseAmountList implements Serializable {
        private static final long serialVersionUID = -3148142613743983579L;
        /**
         * used_amounts 　选填 array[string]
         * <p>
         * 【已用金额】 券的本次使用金额，单位：分。
         */
        private List<Long> usedAmounts = Collections.emptyList();
    }
}
