package cn.com.duiba.supplier.channel.service.api.remoteservice.wx;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.BaseReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.wx.WxV3NotifyReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor.WxDownLoadRequest;
import cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor.WxFavorApplyBankMultiActivityReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor.WxFavorImportUserAgreementNumberRequest;
import cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor.WxFavorQueryBankMultiActivityCouponDetailReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor.WxFavorQueryUserCouponsReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor.WxFavorStocksListReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor.WxFavorUserCouponsReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.BaseResultResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxFavorApplyBankMultiActivityDto;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxFavorDownLoadWriteOffDetailDto;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxFavorImportUserAgreementNumberResultDto;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxFavorNotifyResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxFavorQueryBankMultiActivityCouponDetailDto;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxFavorQueryUserCouponsResultDto;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxFavorStockMerchantsDto;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxFavorStocksDto;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxFavorStocksPauseResultDto;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxFavorStocksRestartResultDto;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxFavorStocksStartResultDto;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxFavorUserCouponsResp;
import cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor.WxPageResp;
import cn.com.duiba.supplier.channel.service.api.enums.order.BizTypeEnum;

/**
 * 微信立减金
 *
 * @author lizhi
 * @date 2023/5/21 4:01 PM
 */
@AdvancedFeignClient
public interface RemoteWxFavorService {

    /**
     * 发放
     * 注意：若结果以mq回调，业务方需要根据业务类型+业务单号幂等<br/>
     * 长时间收不到回调调用查询接口查询<br/>
     *
     * @param request 发放请求参数
     * @return 本次请求是否成功
     */
    BaseResp distribute(BaseReq<WxFavorUserCouponsReq> request);

    /**
     * 查询发放结果
     *
     * @param bizType 业务类型
     *                {@link BizTypeEnum}
     * @param bizNo   业务方唯一单号
     * @return 发放结果
     */
    BaseResultResp<WxFavorUserCouponsResp> distributeResult(Integer bizType, String bizNo);

    /**
     * 获取最新请求参数
     *
     * @param bizType 业务类型
     * @param bizNo   订单号
     * @return 最新请求参数
     */
    WxFavorUserCouponsReq getReqParam(Integer bizType, String bizNo);

    /**
     * 查询批次详情
     *
     * @param mchId             商户号
     * @param stockId           批次号
     * @param stockCreatorMchId 创建批次的商户号
     * @return 批次详情
     */
    WxFavorStocksDto getStocksInfo(String mchId, String stockId, String stockCreatorMchId);

    /**
     * 条件查询批次列表
     *
     * @param req 请求参数
     * @return 批次列表详情
     */
    WxPageResp<WxFavorStocksDto> getStocksInfoList(WxFavorStocksListReq req);

    /**
     * 查询微信立减金批次核销明细Url
     *
     * @param mchId   商户号
     * @param stockId 批次号
     * @return 下载明细链接
     */
    WxFavorDownLoadWriteOffDetailDto queryWxWriteOffDetailUrl(String mchId, String stockId);

    /**
     * 下载微信立减金批次核销明细原始文件，到oss，同步请求
     *
     * @param mchId   商户号
     * @param stockId 批次号
     * @return 原始文件oss cdn地址
     */
    String downloadWxWriteOffDetailAsOssUrl(String mchId, String stockId);

    /**
     * 查询微信立减金批次退款明细Url
     *
     * @param mchId   商户号
     * @param stockId 批次号
     * @return 下载明细链接
     */
    WxFavorDownLoadWriteOffDetailDto queryWxRefundDetailUrl(String mchId, String stockId);

    /**
     * 下载微信立减金批次退款明细原始文件，到oss，同步请求
     *
     * @param mchId   商户号
     * @param stockId 批次号
     * @return 原始文件oss cdn地址
     */
    String downloadWxRefundDetailAsOssUrl(String mchId, String stockId);

    /**
     * 通过微信链接下载微信批次账单明细文本，结果自动解析，并上传到OOS上，结果将以100条为单位，转发到指定MQ上。
     *
     * @param wxDownLoadRequest 微信下载账单请求参数
     */
    void downLoadAndUploadWxBillFileByWxUrl(WxDownLoadRequest wxDownLoadRequest);

    /**
     * 回调验证签名并解密
     *
     * @param req 回调信息
     * @return 结果
     */
    WxFavorNotifyResp notifyValidateAndDecrypt(WxV3NotifyReq req);

    /**
     * 查询立减金详情
     *
     * @param bizType 业务类型
     *                {@link BizTypeEnum}
     * @param bizNo   业务方唯一单号
     * @return 发放结果
     */
    WxFavorUserCouponsResp queryCouponInfo(Integer bizType, String bizNo) throws BizException;

    /**
     * 查询立减金详情（不要超过 50 QPS，微信会限流）
     *
     * @param couponId 优惠券 ID
     * @param openId   openId
     * @param appId    公众账号ID
     * @param mchId    商户编号
     * @return 发放结果
     * @throws BizException 业务异常
     */
    WxFavorUserCouponsResp queryCouponInfoByCouponId(String couponId, String openId, String appId, String mchId) throws BizException;

    /**
     * 激活代金券批次
     *
     * @param mchId             商户号
     * @param stockId           批次号
     * @param stockCreatorMchId 创建批次的商户号
     * @return 激活结果
     */
    WxFavorStocksStartResultDto startStocks(String mchId, String stockId, String stockCreatorMchId);

    /**
     * 重启代金券批次
     *
     * @param mchId             商户号
     * @param stockId           批次号
     * @param stockCreatorMchId 创建批次的商户号
     * @return 激活结果
     */
    WxFavorStocksRestartResultDto restartStocks(String mchId, String stockId, String stockCreatorMchId);

    /**
     * 暂停代金券批次
     *
     * @param mchId             商户号
     * @param stockId           批次号
     * @param stockCreatorMchId 创建批次的商户号
     * @return 激活结果
     */
    WxFavorStocksPauseResultDto pauseStocks(String mchId, String stockId, String stockCreatorMchId);


    /**
     * 导入定向用户协议号API
     *
     * @param request 请求参数
     * @return 激活结果
     */
    WxFavorImportUserAgreementNumberResultDto importUserAgreementNumber(WxFavorImportUserAgreementNumberRequest request);

    /**
     * 查询批次商户详情(每页查询50条)
     *
     * @param mchId
     * @param stockId
     * @param stockCreatorMchId
     * @param offset
     * @return
     */
    WxFavorStockMerchantsDto getStockMerchantsInfo(String mchId, String stockId, String stockCreatorMchId, Long offset);

    /**
     * 根据微信文件url下载账单，获取oss地址
     *
     * @param url   下载url
     * @param mchId 商户号
     * @return oss地址
     */
    String downloadWxBillFileByWxUrlReturnOssUrl(String url, String mchId);

    /**
     * 根据商户号查询用户的券
     *
     * @param req 请求参数
     * @return 券列表
     */
    WxFavorQueryUserCouponsResultDto queryUserCoupons(WxFavorQueryUserCouponsReq req);

    /**
     * 银行多笔立减报名
     *
     * @param req 报名参数
     * @return 报名结果, 包含失败时的错误信息
     */
    WxFavorApplyBankMultiActivityDto applyBankMultiActivity(WxFavorApplyBankMultiActivityReq req);

    /**
     * 查询银行多笔立减券详情，用户先报名，后可查询
     *
     * @param req 查询参数
     * @return 券详情, 包含失败时的错误信息
     */
    WxFavorQueryBankMultiActivityCouponDetailDto queryBankMultiActivityCouponDetail(WxFavorQueryBankMultiActivityCouponDetailReq req);
}
