package cn.com.duiba.supplier.channel.service.api.remoteservice.alipay;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.alipay.AlipayDtBankCustAccountQueryReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.alipay.AlipayDtBankCustAccountInfoResp;

import java.util.List;
import java.util.Map;

/**
 * 
 * @author lizhi
 * @date 2024/1/9 13:50
 */
@AdvancedFeignClient
public interface RemoteAlipayBaseService {

    /**
     * 校验签名
     *
     * @param params 参数
     * @return 校验是否通过
     */
    boolean verifyV1(Map<String, String> params);

    /**
     * 数字分行用户账号查询接口
     * <a href="https://opendocs.alipay.com/pre-apis/09l5u5">官方文档</a>
     * @param req 请求参数
     * @return 账号列表
     */
    List<AlipayDtBankCustAccountInfoResp> dtBankCustAccountQuery(AlipayDtBankCustAccountQueryReq req);
}
