package cn.com.duiba.supplier.channel.service.api.dto.conf;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 支付宝商户配置表
 * @author kjj mybatis generator 
 * @date 2023-04-17
 */
@Data
public class WxpayMchConfCertDto implements Serializable {

    private static final long serialVersionUID = 515364478211699238L;

    /**
     * id 主键
     */
    private Long id;

    /**
     * 微信商户id
     */
    private String mchId;

    /**
     * 证书类型，1-商户证书，2-平台证书
     * {@link cn.com.duiba.supplier.channel.service.enums.WxpayMchCertTypeEnum}
     */
    private Integer certType;

    /**
     * 证书序列号
     */
    private String certSerialNumber;

    /**
     * 证书私钥
     */
    private String privateKey;

    /**
     * 有效时间
     */
    private Date effectiveTime;

    /**
     * 过期时间
     */
    private Date expireTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * pem格式证书
     */
    private String pemCert;
}