package cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @author xuzhigang
 * @date 2025/04/14 22:30
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class CommitFileReq extends StorageRequest {

    /**
     * 操作者unionId。
     * 企业内部应用，调用查询用户详情接口获取unionid参数值。
     * 第三方企业应用，调用查询用户详情接口获取unionid参数值。
     */
    private String unionId;

    /**
     * 文件的名称，带后缀。命名有以下要求：
     * 头尾不能包含空格，否则会自动去除
     * 不能包含特殊字符，包括：制表符、*、"、<、>、|
     * 不能以"."结尾
     */
    private String name;

    /**
     * 添加文件唯一标识。
     * 企业内部应用，调用获取文件上传信息接口获取uploadKey参数值。
     * 第三方企业应用，调用获取文件上传信息接口获取uploadKey参数值。
     */
    private String uploadKey;

    /**
     * 父目录Id。根目录时，该参数是0。
     * 企业内部应用，调用获取文件或文件夹列表接口获取parentId参数值。
     * 第三方企业应用，调用获取文件或文件夹列表接口获取parentId参数值。
     */
    private String parentId;
}
