package cn.com.duiba.supplier.channel.service.api.dto.request.douyin;

import lombok.Data;

import java.io.Serializable;

/**
 * 抖音领券请求体
 */
@Data
public class DouYinReceiveCouponReq implements Serializable {


    private static final long serialVersionUID = -5642170527259427240L;
    /**
     * 用户openid
     * 示例值:2323dfsdf342342
     */
    private String openid;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 活动id
     * 指银行创建券批次活动，生成的活动ID
     */
    private String activityId;

    /**
     * 商户单据号
     * 此次发放凭据号(格式:商户id+日期+流水号)，可包含英文字母，数字，1，，*，-等内容，不允许出现其他不合法符号，商户侧需保持唯一性;若使用相同单据号再次请求发券，则幂等返回上次发券结果，
     * 示例值:89560002019101000121
     */
    private String outRequestNo;

    /**
     * 风控参数
     * 风控参数，json字符串，调用抖音发券需过抖音支付统一风控系统。
     * 示例:{"did":"12340000"
     */
    private String riskInfo;

    /**
     * 商户号
     * 银行入驻抖音支付商家平台分配的商户号(当前线下提供)
     * 示例值:1230000109
     */
    private String mchId;

    /**
     * 应用 id
     * 入驻抖音开放平台时分配的应用id。加密手机号发券模式下无需传该参数
     * 示例值:wxd678efh567hg6787
     *
     */
    private String appId;

    /**
     * 访问 token
     * 通过授权码获取到的access token。加密手机号发券模式下无需传该参数
     * 示例值:qswxd678efh5
     */
    private String accessToken;

    /**
     * 用户权限范围
     * 用户授权后，获取到的操作权限范围，用于发用户券鉴权，加密手机号发券模式下无需传该参数
     * 示例值:abc123
     */
    private String scope;

    /**
     * 用户身份类型
     * 目前仅加密手机号发券时需传入
     * encrypt_phone
     */
    private String identityType = "encrypt_phone";
}
