package cn.com.duiba.supplier.channel.service.api.dto.response.wx.redpacket;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * {
 *  "appId": "", //微信appId
 *  "downInfoId": "", //加盟商ID
 *  "id": "",
 *  "mchBillno": "", //业务单号
 *  "mchId": "",    //当前发放的商户ID
 *  "openid": "",   //接受收红包的用户在wxappid下的openid
 *  "otherOrderId": "", //提单订单编码
 *  "sendListid": "",   //现金订单的微信单号
 *  "status": 0,        //状态0.成功 1.失败
 *  "totalAmount": 0,   //金额单位（分）
 *  }
 *
 * @author xuzhigang
 * @date 2025/2/7 16:19
 **/
@Data
public class KuaikuaishouWxRedPacketResp implements Serializable {
    private static final long serialVersionUID = -7278735776185920242L;

    /**
     * 接受收红包的用户在wxappid下的openid
     */
    @JSONField(name = "openid")
    private String openId;

    /**
     * 加盟商ID
     */
    private String downInfoId;

    /**
     * id
     */
    private String id;

    /**
     * 业务单号
     */
    private String mchBillno;

    /**
     * 当前发放的商户ID
     */
    private String mchId;

    /**
     * 现金订单的微信单号
     */
    @JSONField(name = "sendListid")
    private String sendListId;

    /**
     * 状态
     * {@link cn.com.duiba.supplier.channel.service.api.enums.channel.KuaikuaishouWxRedPacketStatusEnum}
     */
    private String status;

    /**
     * 金额单位（分）
     */
    private Long totalAmount;
}
