package cn.com.duiba.supplier.channel.service.api.dto.request.huafei;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * 银盛数惠直充请求参数
 *
 * @author AI Assistant
 * @date 2025/01/02
 */
@Data
public class YinShengShuHuiHuaFeiReq implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 充值手机号
     */
    @NotBlank(message = "充值手机号不能为空")
    private String mobile;

    /**
     * 商品编号，即面值,单位元
     */
    @NotNull(message = "商品编号不能为空")
    private String goodsCode;

    /**
     * 商户号（可选，不传使用默认配置）
     */
    private String mchId;
} 