package cn.com.duiba.supplier.channel.service.api.dto.request.youku;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 优酷会员直充
 *
 * @author wangguanhua
 */
@Data
public class YoukuReq implements Serializable {

    private static final long serialVersionUID = -270310078429747820L;

    /**
     * 活动 id
     *
     * <p>
     * 商家在优酷平台自助创建或优酷运营帮助创建的活动 id
     * </p>
     */
    @NotNull(message = "活动id不能为空")
    @JSONField(name = "activity_id")
    private String activityId;

    /**
     * 充值手机号
     *
     * <p>
     * type=2 时必传，非白银会员会发送短信通知（短信内容由优酷定义）
     * </p>
     */
    @NotNull(message = "充值手机号不能为空")
    private String mobile;

}
