package cn.com.duiba.supplier.channel.service.api.dto.response.alipay;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author nongfu
 * @Date 2025/6/14 10:16
 */
@Data
public class AliPaySystemOauthTokenResp implements Serializable {

    private static final long serialVersionUID = -4521538811878651984L;

    /**
     * 访问令牌。通过该令牌调用需要授权类接口
     */
    private String accessToken;

    /**
     * 授权token开始时间，作为有效期计算的起点
     */
    private Date authStart;

    /**
     * 令牌类型，permanent表示返回的access_token和refresh_token永久有效，非永久令牌不返回该字段
     */
    private String authTokenType;

    /**
     * 访问令牌的有效时间，单位是秒。【示例值】3600
     */
    private String expiresIn;

    /**
     * 支付宝用户唯一标识
     */
    private String openId;

    /**
     * 刷新令牌的有效时间，单位是秒。
     */
    private String reExpiresIn;

    /**
     * 刷新令牌。通过该令牌可以刷新access_token
     */
    private String refreshToken;

    /**
     * union_id是支付宝用户在开放平台的唯一标识符，在配置应用分组后会返回该值。
     同一用户的union_id在同一分组内应用保持一致。
     */

    private String unionId;

    /**
     * 支付宝用户的唯一标识。以2088开头的16位数字。
     */
    private String userId;
}
