package cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/10/19 10:00
 **/
@Data
public class DeptDetailResponse implements Serializable {
    private static final long serialVersionUID = 3943558163961229406L;

    /**
     * 当群已经创建后，是否有新人加入部门会自动加入该群
     */
    private Boolean autoAddUser;
    /**
     * 开启后，加入该部门的申请将默认同意
     */
    private Boolean autoApproveApply;
    /**
     * 部门简介
     */
    private String brief;
    /**
     * 是否同步创建一个关联此部门的企业群, true表示是, false表示不是
     */
    private Boolean createDeptGroup;
    /**
     * 部门群ID
     */
    private String deptGroupChatId;
    /**
     * 部门ID
     */
    private Long deptId;
    /**
     * 部门的主管列表
     */
    private List<String> deptManagerUseridList;
    /**
     * 可以查看指定隐藏部门的其他人员列表，如果部门隐藏，则此值生效，取值为其他的人员userid组成的数组
     */
    private List<Long> deptPermits;
    /**
     * 扩展字段
     */
    private String extention;
    /**
     * 部门是否来自关联组织
     */
    private Boolean fromUnionOrg;
    /**
     * 部门群是否包含子部门
     */
    private Boolean groupContainSubDept;
    /**
     * 是否隐藏部门, true表示隐藏, false表示显示
     */
    private Boolean hideDept;
    /**
     * 部门名称
     */
    private String name;
    /**
     * 在父部门中的次序值
     */
    private Long order;
    /**
     * 企业群群主ID
     */
    private String orgDeptOwner;
    /**
     * 是否本部门的员工仅可见员工自己, 为true时，本部门员工默认只能看到员工自己
     */
    private Boolean outerDept;
    /**
     * 本部门的员工仅可见员工自己为true时，可以配置额外可见部门
     */
    private List<Long> outerPermitDepts;
    /**
     * 本部门的员工仅可见员工自己为true时，可以配置额外可见人员
     */
    private List<String> outerPermitUsers;
    /**
     * 父部门id，根部门为1
     */
    private Long parentId;
    /**
     * 部门标识字段，开发者可用该字段来唯一标识一个部门，并与钉钉外部通讯录里的部门做映射
     */
    private String sourceIdentifier;
    /**
     * 教育行业部门类型，包括campus,period,grade,class.
     */
    private String tags;
    /**
     * 联系方式（手机号码或座机号码）
     */
    private String telephone;
    /**
     * 可以查看指定隐藏部门的其他人员列表，如果部门隐藏，则此值生效，取值为其他的人员userid组成的数组
     */
    private List<String> userPermits;
}
