package cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor;

import java.io.Serializable;

import com.alibaba.fastjson.annotation.JSONField;

import lombok.Data;
import lombok.ToString;

/**
 * @author lizhi
 * @date 2023/12/27 13:53
 */
@ToString
@Data
public class WxFavorNotifyResp implements Serializable {
    private static final long serialVersionUID = -2814657104112682358L;

    /**
     * 批次创建方商户号。
     */
    @JSONField(name = "stock_creator_mchid")
    private String stockCreatorMchId;

    /**
     * 微信为每个代金券批次分配的唯一id。
     */
    @JSONField(name = "stock_id")
    private String stockId;

    /**
     * 微信为代金券唯一分配的id。
     */
    @JSONField(name = "coupon_id")
    private String couponId;

    /**
     * 单品优惠特定信息。
     */
    @JSONField(name = "singleitem_discount_off")
    private WxFavorSingleItemDiscountOffDto singleItemDiscountOff;

    /**
     * 减至优惠限定字段，仅减至优惠场景有返回。
     */
    @JSONField(name = "discount_to")
    private WxFavorDiscountToDto discountTo;

    /**
     * 代金券名称
     */
    @JSONField(name = "coupon_name")
    private String couponName;

    /**
     * 代金券状态：
     * SENDED：可用(核销通知中不会头这个状态)
     * USED：已实扣
     * EXPIRED：已过期(核销通知中不会头这个状态)
     */
    @JSONField(name = "status")
    private String status;

    /**
     * 代金券描述说明字段。
     */
    @JSONField(name = "description")
    private String description;

    /**
     * 领券时间
     */
    @JSONField(name = "create_time")
    private String createTime;

    /**
     * 类型
     * NORMAL：满减券
     * CUT_TO：减至券
     */
    @JSONField(name = "coupon_type")
    private String couponType;

    /**
     * 是否无资金流
     * true：是
     * false：否
     */
    @JSONField(name = "no_cash")
    private boolean noCash;

    /**
     * 可用开始时间
     */
    @JSONField(name = "available_begin_time")
    private String availableBeginTime;

    /**
     * 可用结束时间
     */
    @JSONField(name = "available_end_time")
    private String availableEndTime;


    /**
     * 是否单品优惠
     */
    @JSONField(name = "singleitem")
    private boolean singleItem;

    /**
     * 普通满减券面额、门槛信息。
     */
    @JSONField(name = "normal_coupon_information")
    private WxFavorFixedNormalCouponDto normalCouponInformation;

    /**
     * 已实扣代金券信息。
     */
    @JSONField(name = "consume_information")
    private WxFavorConsumeInformationDto consumeInformation;

    /**
     * 是否为合单支付
     * 选填
     * 【是否为合单订单】该代金券核销的订单是否是合单订单，枚举值：
     * true：是
     * false：否（不返回此字段 = false）
     */
    @JSONField(name = "is_combine_order")
    private boolean isCombineOrder;

    /**
     * 【合单订单信息】合单订单信息
     */
    @JSONField(name = "combine_order_info")
    private CombineOrderInfoDto combineOrderInfo;
}
