package cn.com.duiba.supplier.channel.service.api.param.conf;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 *
 * 微信商户添加参数
 *
 * @author zzy
 * @create 2025/08/15 13:44
 **/
@Data
@ToString(callSuper = true)
public class AddWxMchParam implements Serializable {
    private static final long serialVersionUID = 3345427742680271486L;
    /**
     * 微信商户号
     */
    private String mchId;
    /**
     * 微信商户名称
     */
    private String mchName;
    /**
     * apiV3秘钥
     */
    private String apiV3Key;
    /**
     * 商户私钥
     */
    private String privateKey;
    /**
     * 商户证书序列号
     */
    private String serialNumber;
    /**
     * 商户证书
     */
    private String merchantCert;
    /**
     * 商户证书生效时间
     */
    private String effectiveTime;
    /**
     * 商户证书失效时间
     */
    private String expireTime;
    /**
     * 微信商户类型
     * 1：内部商户
     * 2：外部商户
     */
    private Integer mchType;
    /**
     * 支付公钥
     */
    private String payPubCert;
    /**
     * 支付公钥序列号
     */
    private String payPubCertSerialNumber;
}
