package cn.com.duiba.supplier.channel.service.api.dto.request.dingtalk;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2025/04/14 22:30
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class GetFileUploadInfoReq extends StorageRequest {

    /**
     * 操作者unionId。
     * 企业内部应用，调用查询用户详情接口获取unionid参数值。
     * 第三方企业应用，调用查询用户详情接口获取unionid参数值。
     */
    private String unionId;

    /**
     * 通过指定上传协议返回不同协议上传所需要的信息。
     * HEADER_SIGNATURE：Header加签
     */
    private String protocol;

    /**
     * 是否需要分片上传。
     * true：需要
     * false：不需要
     */
    private Boolean multipart;
}
