package cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2024/10/21 18:59
 **/
@Data
public class GetApprovalSchemaResponse implements Serializable {
    private static final long serialVersionUID = 2157138682596965562L;

    /**
     * 表单类型。
     */
    public Integer appType;

    /**
     * 表单应用 uuid 或者 corpId。
     */
    public String appUuid;

    /**
     * 代表表单业务含义的类型。
     */
    public String bizType;

    /**
     * 创建人 userId。
     */
    public String creatorUserId;

    /**
     * 业务自定义设置数据。
     */
    public String customSetting;

    /**
     * 引擎类型，取值：
     * 1：页面
     * 0：表单
     */
    public Integer engineType;

    /**
     * <p>This parameter is required.</p>
     *
     * <strong>example:</strong>
     * <p>PROC-17428B8C-6C60-470E-xxxx-64F1037AE067</p>
     */
    public String formCode;

    /**
     * <p>This parameter is required.</p>
     *
     * <strong>example:</strong>
     * <p>FORM-28215C3E-00E3-4118-xxxx-4091F828AF2F</p>
     */
    public String formUuid;

    /**
     * 创建时间的时间戳。
     */
    public String gmtCreate;

    /**
     * 修改时间的时间戳。
     */
    public String gmtModified;

    /**
     * 图标。
     */
    public String icon;

    /**
     * 排序 id。
     */
    public Integer listOrder;

    /**
     * 说明文案。
     */
    public String memo;

    /**
     * 表单名称。
     */
    public String name;

    /**
     * 数据归属者的 id 类型，取值：
     * orgId：企业
     * cid：群
     * uid：人
     */
    public String ownerIdType;

    /**
     * 目标类型，取值：
     * inner：内部
     * outer：外部
     * customer：自定义
     */
    public String procType;

    /**
     * 表单 schema 详情。
     */
    public ApprovalSchemaContent schemaContent;

    /**
     * 状态，取值：
     * PUBLISHED：启用
     * INVALID：停用
     * SAVED：草稿
     */
    public String status;

    /**
     * 可见范围类型
     */
    public String visibleRange;
}
