package cn.com.duiba.supplier.channel.service.api.dto.response.youku;

import cn.com.duiba.supplier.channel.service.api.enums.channel.YiLiStatusEnum;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * 优酷会员翌理直充响应
 * @author yangyukang
 * @date 2024/12/19
 */
@Data
public class YiLiYouKuVipZcResp implements Serializable {

    private static final long serialVersionUID = 4251824693232543154L;
    
    /**
     * 状态码
     */
    private String code;

    /**
     * 状态信息
     */
    private String message;

    /**
     * 商户号
     */
    private String agentId;

    /**
     * 商户订单号
     */
    private String batchNo;

    /**
     * 签名(Md5签名结果)
     */
    private String sign;
    
    /**
     * 流水单号
     */
    private String orderId;
    
    /**
     * 金额
     */
    private String amount;

    /**
     * 订单状态
     *      1待处理 2成功 4失败
     * {@link YiLiStatusEnum}
     */
    private Integer status;
    
    /**
     * 支付时间
     */
    private String payAt;
    
    /**
     * 商品类型
     *      ANP 卡密 DIRECT 直冲
     *  {@link cn.com.duiba.supplier.channel.service.api.enums.channel.YiLiGoodsTypeEnum}
     */
    private String goodsType;
    
    /**
     * 卡列表
     */
    private List<CardDetails> cardList;

    @Data
    @ToString(callSuper = true)
    class CardDetails implements Serializable {

        private static final long serialVersionUID = -4608828645552013144L;
        
        /**
         * 卡号
         */
        private String cardNo;
        
        /**
         * 卡密
         */
        private String password;
    }
} 