package cn.com.duiba.supplier.channel.service.api.dto.response.unionpay;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 银联优惠券通知响应 DTO
 */
@Data
public class UnionPayCallBackDto implements Serializable {

    /** 系统 ID（目前为银联内部系统 ID，后续调整为渠道方代码） */
    private String chnlId;

    /** 流水号（唯一标识一笔通知请求） */
    private String transSeq;

    /** 请求跟踪号（用于上下文串联） */
    private String traceId;

    /** 交易时间（格式：YYYYMMDDHHMMSS） */
    private String transDtTm;

    /** 优惠券 ID（即票券活动 ID）discountId */
    private String couponId;

    /** 活动名称（由业务人员录入） */
    private String couponNm;

    /** 下载数量 / 操作票券数量 */
    private Integer couponNum;

    /**
     * 操作类型：
     * 01：优惠券承兑，
     * 02：优惠券返还，
     * 03：优惠券无操作，
     * 04：优惠券获取，
     * 05：优惠券删除，
     * 06：优惠券过期
     */
    private String operTp;

    /** 券码（优惠券唯一标识） */
    private String couponCd;

    /**
     * 交易类型（仅在 operTp 为 01、02、03 时出现）：
     * 01：消费，31：撤销，04：退货
     */
    private String transTp;

    /**
     * 订单金额（单位：分）：
     * operTp = 01 → 订单金额；
     * transTp = 31 → 撤销金额；
     * operTp = 04 → 应退金额
     */
    private Long orderAt;

    /**
     * 优惠金额（单位：分）：
     * operTp = 01 → 抵扣金额；
     * transTp = 31 → 撤回金额；
     * operTp = 04 → 应退优惠金额
     */
    private Long discountAt;

    /**
     * 交易渠道（仅 operTp 为 01、31、04 时出现）：
     * 0001：线上支付，
     * 0002：二维码支付，
     * 0003：线下 POS
     */
    private String transChnl;

    /** 商户编号（可选） */
    private String mchntCd;

    /** POS 终端号（可选） */
    private String posTmn;
}
