package cn.com.duiba.supplier.channel.service.api.enums.channel;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 企迈券状态枚举
 * @author yangyukang
 * @date 2024/12/19 5:30 PM
 */
@Getter
@AllArgsConstructor
public enum QiMaiCouponStatusEnum {

    UNUSED(0, "未使用"),
    USED(1, "已使用"),
    EXPIRED(2, "已过期"),
    RECOVERED(3, "已回收"),
    PRE_ISSUED(4, "预发");

    /**
     * 状态码
     */
    private final Integer code;

    /**
     * 状态描述
     */
    private final String desc;

    private static final Map<Integer, QiMaiCouponStatusEnum> CODE_MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(QiMaiCouponStatusEnum::getCode, Function.identity(), (v1, v2) -> v2))
    );

    /**
     * 根据状态码获取枚举
     * @param code 状态码
     * @return 对应的枚举，如果不存在则返回null
     */
    public static QiMaiCouponStatusEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return CODE_MAP.get(code);
    }

    /**
     * 根据状态码获取描述
     * @param code 状态码
     * @return 对应的描述，如果不存在则返回"未知状态"
     */
    public static String getDescByCode(Integer code) {
        QiMaiCouponStatusEnum statusEnum = getByCode(code);
        return statusEnum != null ? statusEnum.getDesc() : "未知状态";
    }
}
