package cn.com.duiba.supplier.channel.service.api.remoteservice.supplier;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.supplier.channel.service.api.dto.request.supplier.ShenbianyunQueryBalanceReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.supplier.ShenbianyunQueryUserSigningReq;
import cn.com.duiba.supplier.channel.service.api.dto.request.supplier.ShenbianyunUserSigningReq;
import cn.com.duiba.supplier.channel.service.api.dto.response.supplier.ShenbianyunBalanceDto;
import cn.com.duiba.supplier.channel.service.api.dto.response.supplier.ShenbianyunSigningDto;

/**
 * @author: LuHui
 * @date: 2024/4/17 10:18
 * @description:
 */
@AdvancedFeignClient
public interface RemoteShenbianyunService {

    /**
     * 查询余额
     * @param req
     * @return
     */
    ShenbianyunBalanceDto queryBalance(ShenbianyunQueryBalanceReq req) throws BizException;

    /**
     * 签约
     * @param request
     * @return
     * @throws BizException
     */
    Boolean userSigning(ShenbianyunUserSigningReq request) throws BizException;

    /**
     * 查询签约
     * @param request
     * @return
     * @throws BizException
     */
    ShenbianyunSigningDto queryUserSigning(ShenbianyunQueryUserSigningReq request) throws BizException;

    /**
     * 签约回调解密
     * @param body
     * @return
     * @throws BizException
     */
    ShenbianyunSigningDto userSigningNotify(String body) throws BizException;

}
