package cn.com.duiba.supplier.channel.service.api.dto.request.wx.favor;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 根据商户号查用户的券
 *
 * @author xuzhigang
 * @date 2025/5/7 13:45
 **/
@Data
public class WxFavorQueryUserCouponsReq implements Serializable {

    private static final long serialVersionUID = 5413718669617535718L;

    /**
     * 商户号 调用接口使用，必填
     */
    private String mchId;

    /**
     * openid 　必填 string(128)
     * 【用户标识】用户在商户appid下的唯一标识。
     * 校验规则：该openid需要与接口传入中的appid有对应关系。
     */
    private String openId;

    /**
     * appid 　必填 string(128)
     * 【公众账号ID】微信为发券方商户分配的公众账号ID，接口传入的所有appid应该为公众号的appid（在mp.weixin.qq.com申请的）或APP的appid（在open.weixin.qq.com申请的）。
     * 校验规则：
     * 1、该appid需要与接口传入中的openid有对应关系；
     * 2、该appid需要与调用接口的商户号（即请求头中的商户号）有绑定关系，若未绑定，可参考该指引完成绑定（
     */
    private String appId;

    /**
     * stock_id 　选填 string(20)
     * 【批次号】批次号，是否指定批次号查询，填写available_mchid，该字段不生效。
     */
    private String stockId;

    /**
     * status 　选填 string(6)
     * 【券或消费金状态】代金券或消费金状态：
     * 选填creator_mchid时，
     * SENDED：返回可用
     * USED：返回可用+已实扣
     * 选填available_mchid时，该字段不生效，仅返回 可用 状态的券或消费金。
     */
    private String status;

    /**
     * creator_mchid 　选填 string(20)
     * 【创建批次的商户号】批次创建方商户号。请求参数传创建商户号返回除过期以外所有状态的用户券。creator_mchid与available_mchid二选一，如果同时存在，优先使用creator_mchid。
     */
    private String creatorMchId;

    /**
     * available_mchid 　选填 string(20)
     * 【可用商户号】可用商户号。请求参数传可用商户号返回除过期以外所有状态的用户券。creator_mchid与available_mchid二选一，如果同时存在，优先使用creator_mchid。
     */
    private String availableMchId;

    /**
     * offset 　选填 integer
     * 【分页页码】分页页码，默认0，填写available_mchid，该字段不生效
     */
    private Integer offset;

    /**
     * limit 　选填 integer
     * 【分页大小】分页大小，默认20，填写available_mchid，该字段不生效
     */
    private Integer limit;

    /**
     * business_type 　选填 string
     * 【业务类型】若选择MULTIUSE，则仅返回查询用户拥有的消费金列表
     * 枚举值：
     * MULTIUSE：消费金
     * 可选取值：
     * MULTIUSE: 消费金类型
     */
    private String businessType;
}
