package cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor;

import lombok.Data;

import java.io.Serializable;

/**
 * 导入定向用户协议号API结果
 *
 * @author lfh
 **/
@Data
public class WxFavorImportUserAgreementNumberResultDto implements Serializable {

    private static final long serialVersionUID = 7272323004708883276L;
    /**
     * 银行类型
     * 用于标识协议号所属的银行以及卡类型(信用卡或借记卡)。采用字符串类型的银行标识，
     */
    private String bankType;

    /**
     * 创建上传任务的时间
     * 时间格式采用遵循rfc3339标准格式，格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。
     */
    private String createTime;

    /**
     * 失败数
     * 匹配失败的协议号数。仅当任务状态是FINISHED时，该数据才有效
     */
    private Integer failCount;
    /**
     * 任务上传的文件名
     */
    private String filename;

    /**
     * 号码包id
     */
    private String packageId;

    /**
     * 任务状态
     * 上传任务的状态
     * PROCESSING：处理中，上传任务处理中，请等待
     * FINISHED：已完成，上传任务已处理完成，任务上传的文件中的用户已导入到号码包中
     */
    private String status;

    /**
     * 成功数
     * 匹配成功的协议号数。仅当任务状态是FINISHED时，该数据才有效
     */
    private Integer successCount;
    /**
     * 匹配成功的微信用户数
     * 匹配成功的微信用户数，不小于匹配成功的协议号数。
     * 当一张银行卡被用户绑定到不同微信号时，才可能出现一个协议号对应多个微信账户的情况。
     * 仅当任务状态是FINISHED时，该数据才有效
     */
    private Integer successUserCount;
    /**
     * 上传任务
     * 上传任务的主键，唯一定义此资源的标识
     */
    private String taskId;

    /**
     * 上传任务最近一次更新的时间
     * 时间格式采用遵循rfc3339标准格式，
     * 格式为yyyy-MM-DDTHH:mm:ss+TIMEZONE，yyyy-MM-DD表示年月日，
     * T出现在字符串中，表示time元素的开头，HH:mm:ss表示时分秒，
     * TIMEZONE表示时区（+08:00表示东八区时间，领先UTC 8小时，即北京时间）。
     * 例如：2015-05-20T13:29:35.+08:00表示，北京时间2015年5月20日 13点29分35秒。
     */
    private String updateTime;
}
