package cn.com.duiba.supplier.channel.service.api.enums.channel;

import lombok.Getter;

import java.util.Arrays;
import java.util.List;

/**
 * @author cxw
 * @date 2024/07/19
 */
@Getter
public enum XiaoJuCodeEnum {

    // 以下状态为进行中
    OK(200, "成功"),


    // 以下状态直接失败
    OPEN_ACTIVITY_IS_NOT_EXIST(90006,"权益活动不存在"),
    OPEN_ACTIVITY_IS_NOT_IN_ACTIVITY(90007,"权益活动不在活动期间，无法绑定权益"),
    USER_QUERY_INFO_ERROR(90008,"用户信息注册异常，绑定营销权益失败"),
    OPEN_BIND_COUPON_ERROR(90009,"绑券失败"),
    ;

    public static final List<String> ERROR_NAME_LIST = Arrays.asList(OPEN_ACTIVITY_IS_NOT_EXIST.name(), OPEN_ACTIVITY_IS_NOT_IN_ACTIVITY.name(),
            USER_QUERY_INFO_ERROR.name(), OPEN_BIND_COUPON_ERROR.name());
            ;


    private final Integer code;
    private final String message;

    XiaoJuCodeEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }


}
