package cn.com.duiba.supplier.channel.service.api.enums.express;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 物流状态（0在途，1揽收，2疑难，3签收，4退签，5派件，6退回，7转投）
 *
 * @author wangguanhua
 */
@Getter
@AllArgsConstructor
public enum ExpressTrackStatusEnum {

    NO_INFO(-1, "暂无物流轨迹信息"),
    IN_TRANSIT(0, "在途"),
    PICK_UP(1, "揽收"),
    DIFFICULT(2, "疑难"),
    RECEIVED(3, "签收"),
    SIGN_OUT(4, "退签"),
    DELIVERY(5, "派件"),
    REFUND(6, "退回"),
    SWITCH(7, "转投"),
    ;

    /**
     * 状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;

}
