package cn.com.duiba.supplier.channel.service.api.enums.wx;


import cn.com.duiba.boot.exception.BizException;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *  微信账单类型
 *  @auther lyj
 */
@Getter
@AllArgsConstructor
public enum WxBillTypeEnum {

    /**
     * 核销
     */
    WRITE_OFF("hx", 0),
    /**
     * 退款
     */
    REFUND("refund", 1),
    ;


    private final String type;

    private final Integer code;

    public static WxBillTypeEnum getByCode(Integer code) throws BizException {
        for (WxBillTypeEnum billType : WxBillTypeEnum.values()) {
            if (billType.getCode().equals(code)) {
                return billType;
            }
        }
        throw new BizException("Unexpected WxBillTypeEnum value code=" + code);
    }
}
