package cn.com.duiba.supplier.channel.service.api.dto.request.supplier;

import cn.com.duiba.supplier.channel.service.api.enums.channel.ShenBianYunPaymentTypeEnum;
import lombok.Data;

import java.io.Serializable;

@Data
public class ShenbianyunUserSigningReq implements Serializable {

    private static final long serialVersionUID = 5363900991660935199L;
    /**
     * 商户号
     */
    private String mchId;

    /**
     * 用户姓名
     */
    private String name;

    /**
     * 银行卡号/支付宝账号（手机号或邮箱）/微信 openid
     */
    private String cardNo;

    /**
     * 身份证号（年龄限制一般为 18-65）
     */
    private String idCard;

    /**
     * 银行预留手机号（四要素会校验手机号真实性、其他目前只校验格式（^(1[2,3,4,5,6,7,8,9][0-9])\d{8}$）
     */
    private String mobile;

    /**
     * 签约方式 0：银行卡，1：支付宝，2：微信
     * @see ShenBianYunPaymentTypeEnum
     */
    private Integer paymentType;
}
