package cn.com.duiba.supplier.channel.service.api.dto.response.dingtalk;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author xuzhigang
 * @date 2024/10/22 11:35
 **/
@Data
public class GetApprovalProcessForecastResponse implements Serializable {
    private static final long serialVersionUID = 8734249181450111606L;

    /**
     * 是否预测成功，成功返回true。
     */
    public Boolean isForecastSuccess;

    /**
     * 是否静态流程。
     * true：
     * false：
     */
    public Boolean isStaticWorkflow;

    /**
     * 表单的唯一码。
     * <strong>example:</strong>
     * <p>PROC-2B60E506-D6CB-43F3-B661-359B27F90947</p>
     */
    public String processCode;

    /**
     * 流程ID，暂无使用场景。
     *
     * <strong>example:</strong>
     * <p>63657309999</p>
     */
    public Long processId;

    /**
     * 用户id。
     */
    public String userId;

    /**
     * 工作流节点规则。
     */
    public List<ApprovalProcessForecastWorkFlowActivityRule> workflowActivityRules;

    /**
     * 工作流节点流。
     */
    public List<ApprovalProcessForecastWorkFlowNode> workflowForecastNodes;
}
