package cn.com.duiba.supplier.channel.service.api.dto.response.wx.favor;


import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class WxCouponBillDto implements Serializable {

    private static final long serialVersionUID = 5977165051669687589L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 微信立减金主键
     */
    private Long wxCouponId;

    /**
     * 微信批次号
     */
    private String stockId;

    /**
     * 优惠券ID
     */
    private String couponId;

    /**
     * 优惠类型
     */
    private String couponType;

    /**
     * 优惠券类型描述
     */
    private String couponTypeDesc;

    /**
     * 订单总金额（单位:分）
     */
    private Long orderTotalMoney;

    /**
     * 优惠券金额（单位:分）
     */
    private Long couponMoney;

    /**
     * 交易类型（1-支付，2-退款）
     */
    private Long tradeType;

    /**
     * 支付单号
     */
    private String payOrderNo;

    /**
     * 消耗时间
     */
    private Date costTime;

    /**
     * 银行流水号
     */
    private String bankNo;


    /**
     * 消耗商户号
     */
    private String useMchId;

    /**
     * 设备号
     */
    private String deviceNo;

    /**
     * 单品信息
     */
    private String couponDetail;

    /**
     * 额外信息（消耗商户号，设备号，消耗门店编码，消耗门店编号）
     */
    private String extra;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

}
