/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.response.PromotionCouponSellerSearchResponse;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromotionCouponSellerSearchRequest
extends BaseTaobaoRequest<PromotionCouponSellerSearchResponse> {
    private Long currentPage;
    private Long pageSize;
    private String sellerNick;
    private String spreadIds;

    public void setCurrentPage(Long currentPage) {
        this.currentPage = currentPage;
    }

    public Long getCurrentPage() {
        return this.currentPage;
    }

    public void setPageSize(Long pageSize) {
        this.pageSize = pageSize;
    }

    public Long getPageSize() {
        return this.pageSize;
    }

    public void setSellerNick(String sellerNick) {
        this.sellerNick = sellerNick;
    }

    public String getSellerNick() {
        return this.sellerNick;
    }

    public void setSpreadIds(String spreadIds) {
        this.spreadIds = spreadIds;
    }

    public String getSpreadIds() {
        return this.spreadIds;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.promotion.coupon.seller.search";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("current_page", (Object)this.currentPage);
        txtParams.put("page_size", (Object)this.pageSize);
        txtParams.put("seller_nick", this.sellerNick);
        txtParams.put("spread_ids", this.spreadIds);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<PromotionCouponSellerSearchResponse> getResponseClass() {
        return PromotionCouponSellerSearchResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkMinValue(this.currentPage, 1L, "currentPage");
        RequestCheckUtils.checkMaxValue(this.pageSize, 20L, "pageSize");
        RequestCheckUtils.checkMinValue(this.pageSize, 1L, "pageSize");
        RequestCheckUtils.checkMaxListSize(this.spreadIds, 20, "spreadIds");
    }
}

