/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.PromotionCouponSendResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PromotionCouponSendRequest
extends BaseTaobaoRequest<PromotionCouponSendResponse> {
    private String buyerIds;
    private String buyerNick;
    private Long couponId;
    private String ouidData;

    public void setBuyerIds(String buyerIds) {
        this.buyerIds = buyerIds;
    }

    public String getBuyerIds() {
        return this.buyerIds;
    }

    public void setBuyerNick(String buyerNick) {
        this.buyerNick = buyerNick;
    }

    public String getBuyerNick() {
        return this.buyerNick;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

    public Long getCouponId() {
        return this.couponId;
    }

    public void setOuidData(String ouidData) {
        this.ouidData = ouidData;
    }

    public void setOuidData(List<OuidData> ouidData) {
        this.ouidData = new JSONWriter(false, true).write(ouidData);
    }

    public String getOuidData() {
        return this.ouidData;
    }

    @Override
    public String getApiMethodName() {
        return "taobao.promotion.coupon.send";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("buyer_ids", this.buyerIds);
        txtParams.put("buyer_nick", this.buyerNick);
        txtParams.put("coupon_id", (Object)this.couponId);
        txtParams.put("ouid_data", this.ouidData);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<PromotionCouponSendResponse> getResponseClass() {
        return PromotionCouponSendResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkMaxListSize(this.buyerIds, 999, "buyerIds");
        RequestCheckUtils.checkMaxListSize(this.buyerNick, 100, "buyerNick");
        RequestCheckUtils.checkNotEmpty(this.couponId, "couponId");
        RequestCheckUtils.checkObjectMaxListSize(this.ouidData, 999, "ouidData");
    }

    public static class OuidData
    extends TaobaoObject {
        private static final long serialVersionUID = 7125976716158649171L;
        @ApiField(value="ouid")
        private String ouid;

        public String getOuid() {
            return this.ouid;
        }

        public void setOuid(String ouid) {
            this.ouid = ouid;
        }
    }
}

