package cn.com.duiba.thirdparty.api.yaduo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdparty.dto.yaduo.RefundQueryReqDto;
import cn.com.duiba.thirdparty.dto.yaduo.RefundQueryRespDto;
import cn.com.duiba.thirdparty.dto.yaduo.SalesRefundPushReqDto;
import cn.com.duiba.thirdparty.dto.yaduo.SalesRefundPushRespDto;
import cn.com.duiba.thirdparty.dto.yaduo.TradePushReqDto;
import cn.com.duiba.thirdparty.dto.yaduo.TradePushRespDto;


/**
 * 亚朵外部接口调用
 *
 * @author wgh
 */
@AdvancedFeignClient
public interface RemoteYaduoService {

    /**
     * 创建原始订单
     *
     * @param tradePushReqDto 创建原始订单入参
     * @return {@link TradePushRespDto}
     */
    TradePushRespDto tradePush(TradePushReqDto tradePushReqDto);

    /**
     * 创建原始退款单
     *
     * @param salesRefundPushReqDto 创建原始退款单入参
     * @return {@link SalesRefundPushRespDto}
     */
    SalesRefundPushRespDto salesRefundPush(SalesRefundPushReqDto salesRefundPushReqDto);

    /**
     * 查询退换管理
     *
     * @param refundQueryReqDto 查询退换管理入参
     * @return {@link RefundQueryRespDto}
     */
    RefundQueryRespDto refundQuery(RefundQueryReqDto refundQueryReqDto);
}
