package cn.com.duiba.thirdparty.dto.yaduo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * trade_push.php（查询退换管理）入参DTO
 *
 * @author wgh
 */
@Data
public class RefundQueryReqDto implements Serializable {

    private static final long serialVersionUID = 8766451435443177573L;

    /**
     * 开始时间（yyyy-MM-dd HH:mm:ss）
     */
    @JSONField(name = "start_time", format = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    /**
     * 结束时间（yyyy-MM-dd HH:mm:ss）
     */
    @JSONField(name = "end_time", format = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /**
     * 页号
     */
    @JSONField(name = "page_no")
    private Integer pageNo;

    /**
     * 分页大小
     */
    @JSONField(name = "page_size")
    private Integer pageSize;

}
