package cn.com.duiba.thirdparty.dto.yaduo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * trade_push.php（查询退换管理）回参DTO
 * <a href="https://open.wangdian.cn/qyb/open/apidoc/doc?path=refund_query.php">原接口文档</a>
 *
 * @author wgh
 */
@NoArgsConstructor
@Data
public class RefundQueryRespDto implements Serializable {

    private static final long serialVersionUID = -1294997983691033336L;

    /**
     * 错误码（状态码:0表示成功,其他表示失败）
     */
    @JSONField(name = "code")
    private Integer code;

    /**
     * 错误原因
     */
    @JSONField(name = "message")
    private String message;

    /**
     * 满足条件的总条数
     */
    @JSONField(name = "total_count")
    private String totalCount;

    /**
     * 当前页的退换单数据
     */
    @JSONField(name = "refunds")
    private List<RefundsDTO> refunds;

    @NoArgsConstructor
    @Data
    public static class RefundsDTO implements Serializable {
        private static final long serialVersionUID = -3058823129869748247L;
        @JSONField(name = "refund_id")
        private String refundId;
        @JSONField(name = "refund_no")
        private String refundNo;
        @JSONField(name = "created")
        private String created;
        @JSONField(name = "src_no")
        private String srcNo;
        @JSONField(name = "type")
        private String type;
        @JSONField(name = "process_status")
        private String processStatus;
        @JSONField(name = "swap_trade_id")
        private String swapTradeId;
        @JSONField(name = "status")
        private String status;
        @JSONField(name = "pay_account")
        private String payAccount;
        @JSONField(name = "pay_no")
        private String payNo;
        @JSONField(name = "goods_amount")
        private String goodsAmount;
        @JSONField(name = "refund_amount")
        private String refundAmount;
        @JSONField(name = "guarantee_mode")
        private String guaranteeMode;
        @JSONField(name = "cs_status")
        private String csStatus;
        @JSONField(name = "sales_tid")
        private String salesTid;
        @JSONField(name = "post_amount")
        private String postAmount;
        @JSONField(name = "other_amount")
        private String otherAmount;
        @JSONField(name = "paid")
        private String paid;
        @JSONField(name = "tid")
        private String tid;
        @JSONField(name = "sales_trade_id")
        private String salesTradeId;
        @JSONField(name = "buyer_nick")
        private String buyerNick;
        @JSONField(name = "receiver_name")
        private String receiverName;
        @JSONField(name = "receiver_address")
        private String receiverAddress;
        @JSONField(name = "receiver_telno")
        private String receiverTelno;
        @JSONField(name = "return_name")
        private String returnName;
        @JSONField(name = "return_mobile")
        private String returnMobile;
        @JSONField(name = "return_telno")
        private String returnTelno;
        @JSONField(name = "exchange_amount")
        private String exchangeAmount;
        @JSONField(name = "return_address")
        private String returnAddress;
        @JSONField(name = "swap_receiver")
        private String swapReceiver;
        @JSONField(name = "swap_mobile")
        private String swapMobile;
        @JSONField(name = "swap_telno")
        private String swapTelno;
        @JSONField(name = "swap_province")
        private String swapProvince;
        @JSONField(name = "swap_city")
        private String swapCity;
        @JSONField(name = "swap_district")
        private String swapDistrict;
        @JSONField(name = "swap_area")
        private String swapArea;
        @JSONField(name = "swap_address")
        private String swapAddress;
        @JSONField(name = "refund_time")
        private String refundTime;
        @JSONField(name = "remark")
        private String remark;
        @JSONField(name = "modified")
        private String modified;
        @JSONField(name = "actual_refund_amount")
        private String actualRefundAmount;
        @JSONField(name = "guarante_refund_amount")
        private String guaranteRefundAmount;
        @JSONField(name = "outer_no")
        private String outerNo;
        @JSONField(name = "return_logistics_name")
        private String returnLogisticsName;
        @JSONField(name = "return_logistics_no")
        private String returnLogisticsNo;
        @JSONField(name = "direct_refund_amount")
        private String directRefundAmount;
        @JSONField(name = "finish_time")
        private String finishTime;
        @JSONField(name = "shop_no")
        private String shopNo;
        @JSONField(name = "shop_name")
        private String shopName;
        @JSONField(name = "platform_id")
        private String platformId;
        @JSONField(name = "api_outer_no")
        private String apiOuterNo;
        @JSONField(name = "customer_no")
        private String customerNo;
        @JSONField(name = "customer_name")
        private String customerName;
        @JSONField(name = "swap_zip")
        private Object swapZip;
        @JSONField(name = "swap_logistics_type")
        private String swapLogisticsType;
        @JSONField(name = "swap_logistics_name")
        private String swapLogisticsName;
        @JSONField(name = "warehouse_no")
        private String warehouseNo;
        @JSONField(name = "creator_name")
        private String creatorName;
        @JSONField(name = "swap_warehouse_no")
        private String swapWarehouseNo;
        @JSONField(name = "refund_reason")
        private String refundReason;
        @JSONField(name = "swap_trade_no")
        private String swapTradeNo;

        /**
         * 驳回原因名称
         */
        @JSONField(name = "revert_reason_info")
        private String revertReasonInfo;

        @JSONField(name = "refund_order_list")
        private List<RefundOrderListDTO> refundOrderList;

        @NoArgsConstructor
        @Data
        public static class RefundOrderListDTO implements Serializable {
            private static final long serialVersionUID = -4672449127718983578L;
            @JSONField(name = "order_id")
            private String orderId;
            @JSONField(name = "refund_id")
            private String refundId;
            @JSONField(name = "oid")
            private String oid;
            @JSONField(name = "tid")
            private String tid;
            @JSONField(name = "process_status")
            private String processStatus;
            @JSONField(name = "order_num")
            private String orderNum;
            @JSONField(name = "cost_price")
            private String costPrice;
            @JSONField(name = "price")
            private String price;
            @JSONField(name = "original_price")
            private String originalPrice;
            @JSONField(name = "discount")
            private String discount;
            @JSONField(name = "paid")
            private String paid;
            @JSONField(name = "refund_num")
            private String refundNum;
            @JSONField(name = "total_amount")
            private String totalAmount;
            @JSONField(name = "refund_order_amount")
            private String refundOrderAmount;
            @JSONField(name = "spec_no")
            private String specNo;
            @JSONField(name = "spec_id")
            private String specId;
            @JSONField(name = "goods_name")
            private String goodsName;
            @JSONField(name = "spec_name")
            private String specName;
            @JSONField(name = "suite_no")
            private String suiteNo;
            @JSONField(name = "suite_name")
            private String suiteName;
            @JSONField(name = "suite_num")
            private String suiteNum;
            @JSONField(name = "stockin_num")
            private String stockinNum;
            @JSONField(name = "remark")
            private String remark;
            @JSONField(name = "market_price")
            private String marketPrice;
            @JSONField(name = "spec_code")
            private String specCode;
            @JSONField(name = "is_sn_enable")
            private String isSnEnable;
            @JSONField(name = "goods_no")
            private String goodsNo;
            @JSONField(name = "sales_tid")
            private String salesTid;
        }
    }
}
