package cn.com.duiba.thirdparty.dto.yaduo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * sales_refund_push.php（创建原始退款单）入参DTO
 *
 * @author wgh
 */
@Data
public class SalesRefundPushReqDto implements Serializable {

    private static final long serialVersionUID = -7507023212237091569L;

    /**
     * 退款单节点
     */
    @JSONField(name = "api_refund_list")
    private List<ApiRefundListItem> apiRefundList;

    /**
     * 退款单节点项
     *
     * @author wgh
     */
    @Data
    public static class ApiRefundListItem implements Serializable {

        private static final long serialVersionUID = -1377472302479921623L;

        /**
         * 平台ID，输入固定值127
         */
        @JSONField(name = "platform_id")
        private Integer platformId;

        /**
         * 店铺编号
         */
        @JSONField(name = "shop_no")
        private String shopNo;

        /**
         * 平台销售订单号
         */
        @JSONField(name = "tid")
        private String tid;

        /**
         * 平台退款/退货单号
         */
        @JSONField(name = "refund_no")
        private String refundNo;

        /**
         * 平台售后类型（type=1：退款(未发货退款)；type=2：退款不退货；type=3：退货）
         */
        @JSONField(name = "type")
        private Integer type;

        /**
         * 平台售后状态（可选值：wait_seller_agree（申请退款），  seller_refuse（拒绝退款） ， closed（退款关闭） ，goods_returning（待退货） goods_receiving（待收货），success（退款成功））
         */
        @JSONField(name = "status")
        private String status;

        /**
         * 买家昵称
         */
        @JSONField(name = "buyer_nick")
        private String buyerNick;

        /**
         * 单据创建时间（yyyy-MM-dd HH:mm:ss）
         */
        @JSONField(name = "refund_time", format = "yyyy-MM-dd HH:mm:ss")
        private Date refundTime;

        /**
         * 售后子订单
         */
        @JSONField(name = "order_list")
        private List<OrderListItem> orderList;

        /**
         * 售后子订单项
         *
         * @author wgh
         */
        @Data
        public static class OrderListItem implements Serializable {

            private static final long serialVersionUID = -3917959642468072733L;

            /**
             * 平台订单子订单编号
             */
            @JSONField(name = "oid")
            private String oid;

            /**
             * 退货货品数量
             */
            @JSONField(name = "num")
            private BigDecimal num;
        }

    }


}
