package cn.com.duiba.thirdpartyvnew.api.boc;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.boc.IdentityDataDto;
import cn.com.duiba.thirdpartyvnew.dto.boc.LabelDataReqParam;
import cn.com.duiba.thirdpartyvnew.dto.boc.PublicDataReqParam;
import cn.com.duiba.thirdpartyvnew.dto.boc.UnionNoReqParam;
import cn.com.duiba.thirdpartyvnew.dto.boc.UserJoinActivityDataDto;
import cn.com.duiba.thirdpartyvnew.dto.boc.UserPvAndUvDataDto;
import com.alibaba.fastjson.JSONObject;

import java.io.IOException;
import java.util.List;

/**
 * 福建中行上送接口
 * @author chenzhenxing
 * @date 2021/11/10 5:14 下午
 */
@AdvancedFeignClient
public interface RemoteFjBocService {

    JSONObject duibaDataUpload(List<IdentityDataDto> dataDtoList) throws IOException;
    /**
     * 公众号数据上送接口
     * @param publicDataReqParam
     * @return
     * @throws IOException
     */
    JSONObject wxDataExport(PublicDataReqParam publicDataReqParam) throws IOException;

    /**
     * 外部第三方标签数据上送接口
     * @param dataRerParam
     * @return
     * @throws IOException
     */
    JSONObject labelDataExport(LabelDataReqParam dataRerParam) throws IOException;

    /**
     * union_no查询接口
     * @param reqParam
     * @return
     * @throws IOException
     */
    JSONObject getUnionNo(UnionNoReqParam reqParam) throws IOException;

    String verifyUser(String openId);

    /**
     * 每日用户参与权益活动接口
     */
    JSONObject sendUserJoinActivityDailyData(List<UserJoinActivityDataDto> userJoinActivityDataList);

    /**
     * 每日活动PV/UV接口
     * @param userPvAndUvDataList
     * @return
     */
    JSONObject sendUserPvAndUvDailyData(List<UserPvAndUvDataDto> userPvAndUvDataList);
}
