package cn.com.duiba.thirdpartyvnew.api.nmggs;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.nmggs.TaskInfoDto;
import cn.com.duiba.thirdpartyvnew.dto.nmggs.UserBaseInfoDto;
import cn.com.duiba.thirdpartyvnew.dto.nmggs.UserGradeInfoDto;

import java.util.List;

/**
 * @author: LuHui
 * @date: 2023/9/21 10:12
 * @description: 内蒙古国寿
 */
@AdvancedFeignClient
public interface RemoteNeiMengGuGuoShouService {

    /**
     * 获取用户完成任务列表
     *
     * @param openId
     * @return
     */
    List<TaskInfoDto> getCompleteTaskList(String openId);

    /**
     * 获取openId
     *
     * @param authorizeCode 前端授权码
     * @return
     */
    String getOpenId(String authorizeCode);

    /**
     * 获取用户基本信息
     *
     * @param openId
     * @return
     */
    UserBaseInfoDto getUserBaseInfo(String openId);

    /**
     * 获取用户等级信息
     *
     * @param idNo 身份证号
     * @param name 姓名
     * @return
     */
    UserGradeInfoDto getUserGradeInfo(String idNo, String name);
}
