package cn.com.duiba.thirdpartyvnew.dto.jingneng;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 会员积分添加入参DTO
 *
 * @author wgh
 */
@NoArgsConstructor
@Data
public class ConsumeCreditRequestReqDto implements Serializable {

    private static final long serialVersionUID = -9058316955343086554L;

    @JSONField(name = "channelId")
    private Integer channelId;
    @JSONField(name = "creditPointMethodCode")
    private String creditPointMethodCode;
    @JSONField(name = "creditPointMethodId")
    private Integer creditPointMethodId;
    @JSONField(name = "creditPointMethodName")
    private String creditPointMethodName;
    @JSONField(name = "expiryDate")
    private String expiryDate;

    /**
     * 会员ID不能为空
     */
    @JSONField(name = "memberId")
    private String memberId;

    /**
     * 积分数量不能为空
     */
    @JSONField(name = "number")
    private Integer number;

    @JSONField(name = "orderNumber")
    private String orderNumber;

    /**
     * 积分类型默认填1
     */
    @JSONField(name = "pointTypeId")
    private Integer pointTypeId = 1;
    @JSONField(name = "remark")
    private String remark;
    @JSONField(name = "storeCode")
    private String storeCode;
    @JSONField(name = "storeName")
    private String storeName;
    @JSONField(name = "transactionDate")
    private String transactionDate;
    @JSONField(name = "transactionNumber")
    private String transactionNumber;
}
