package cn.com.duiba.thirdpartyvnew.enums;

/**
 * http请求结果类型
 */
public enum HttpRequestResultType {
    /**
     * http消息发送失败
     */
    FAILED("failed"),

    /**
     * http消息取消
     */
    CANCELLED("cancelled"),

    /**
     * http消息请求完成
     */
    COMPLETED("completed");

    public static HttpRequestResultType getByMsg(String msg){
        for(HttpRequestResultType type : values()){
            if(type.getMsg().equals(msg)){
                return type;
            }
        }
        return null;
    }

    private final String msg;

    HttpRequestResultType(String msg) {
        this.msg = msg;
    }

    public String getMsg() {
        return msg;
    }
}
