package cn.com.duiba.thirdpartyvnew.dto.yaduo;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * logistics_sync_query.php（查询物流同步）回参DTO
 *
 * @author wgh
 */
@NoArgsConstructor
@Data
public class LogisticsSyncQueryRespDto implements Serializable {

    private static final long serialVersionUID = 986233549568346876L;

    @JSONField(name = "code")
    private Integer code;
    @JSONField(name = "message")
    private String message;
    @JSONField(name = "trades")
    private List<TradesDTO> trades;

    @NoArgsConstructor
    @Data
    public static class TradesDTO implements Serializable{
        private static final long serialVersionUID = -7353044753249293816L;
        @JSONField(name = "rec_id")
        private String recId;
        @JSONField(name = "shop_no")
        private String shopNo;
        @JSONField(name = "tid")
        private String tid;
        @JSONField(name = "logistics_type")
        private String logisticsType;
        @JSONField(name = "logistics_no")
        private String logisticsNo;
        @JSONField(name = "delivery_term")
        private String deliveryTerm;
        @JSONField(name = "consign_time")
        private String consignTime;
        @JSONField(name = "oids")
        private String oids;
        @JSONField(name = "is_part_sync")
        private String isPartSync;
        @JSONField(name = "platform_id")
        private String platformId;
        @JSONField(name = "trade_id")
        private String tradeId;
        @JSONField(name = "logistics_name_erp")
        private String logisticsNameErp;
        @JSONField(name = "logistics_code_erp")
        private String logisticsCodeErp;
        @JSONField(name = "logistics_name")
        private String logisticsName;
    }
}
