package cn.com.duiba.thirdpartyvnew.enums.virtual;

public enum VirtualItemChannelEnum {

    FULU("fulu", "福禄"),
    HUAZHU("huazhu", "华住"),
    BILIBILI("bilibili", "哔哩哔哩"),
    PU_SHANG("pushang", "浦上"),
    SHANG_YU("shangyu", "尚娱"),
    QING_TIAN("qingtian", "晴天"),
    SUCCESS("success","成功"),
    FAIL("fail","失败"),
    TIME_OUT("timeout","超时"),
    ALIPAY_IGR("alipayIGR", "支付宝立减金"),
    ;

    private String code;
    private String desc;

    VirtualItemChannelEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static VirtualItemChannelEnum getByCode(String code) {
        for (VirtualItemChannelEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
