package cn.com.duiba.thirdpartyvnew.dto.lzlj.request;

import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
@Data
@NoArgsConstructor
public class ProductRequestData implements Serializable {
    private String source; // 系统来源
    private String prodCode; // 产品编码
    private String prodName; // 产品名称
    private String prodShowName; // 产品展示名称
    private String prodShowSeries; // 商城展示分类
    private String prodImagePath; // 产品默认主图 URL 地址
    private BigDecimal prodPrice; // 市场价
    private BigDecimal prodPromoPrice; // 结算价
    private List<String> prodImagePathList; // 产品主图集合（URL 地址列表）
    private List<String> prodDetailImagePathList; // 产品详情图集合（URL 地址列表）
    private String prodDesption; // 产品说明（可选）

    @Builder
    public ProductRequestData(String source, String prodCode, String prodName, String prodShowName, String prodShowSeries, String prodImagePath, BigDecimal prodPrice, BigDecimal prodPromoPrice, List<String> prodImagePathList, List<String> prodDetailImagePathList, String prodDesption) {
        this.source = source;
        this.prodCode = prodCode;
        this.prodName = prodName;
        this.prodShowName = prodShowName;
        this.prodShowSeries = prodShowSeries;
        this.prodImagePath = prodImagePath;
        this.prodPrice = prodPrice;
        this.prodPromoPrice = prodPromoPrice;
        this.prodImagePathList = prodImagePathList;
        this.prodDetailImagePathList = prodDetailImagePathList;
        this.prodDesption = prodDesption;
    }
}
