package cn.com.duiba.thirdpartyvnew.api.yht;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.thirdpartyvnew.dto.yht.YhtOrderData;
import cn.com.duiba.thirdpartyvnew.dto.yht.YhtOrderReqInfo;
import cn.com.duiba.thirdpartyvnew.dto.yht.YhtPointData;
import cn.com.duiba.thirdpartyvnew.dto.yht.YhtResult;
import cn.com.duiba.thirdpartyvnew.dto.yht.YhtUserInfoData;

@AdvancedFeignClient
public interface RemoteYhtService {

    /**
     * 查询用户积分信息
     * @param uid 用户id
     * @return 用户积分信息
     */
    YhtResult<YhtPointData> queryYhtPointData(String uid) throws BizException;

    /**
     * 用户订单信息
     */
    YhtResult<YhtOrderData> queryYhtOrderData(YhtOrderReqInfo reqInfo) throws BizException;

    /**
     * 查询用户订单信息
     * @param uid 用户id
     */
    YhtResult<YhtUserInfoData> queryUserInfoData(String uid) throws BizException;
}
