package cn.com.duiba.thirdpartyvnew.dto.dcjj;

import lombok.Data;

import java.io.Serializable;

/**
 * 大成基金领取回调
 */
@Data
public class DcjjDrawCallBackParam implements Serializable {
    /**
     * 领取成功
     */
    public static final String SUCCESS = "success";
    /**
     * 领取失败
     */
    public static final String FAIL = "failure";

    /**
     * 其他回调
     */
    public static Integer CALL_BACK_NORMAL = 1;
    /**
     * 充值回调
     */
    public static Integer CALL_BACK_VIRTUAL = 2;
    /**
     * 实物回调
     */
    public static Integer CALL_BACK_OBJECT = 3;

    /** 签名 */
    private String sign;

    /** appKey */
    private String appKey;

    /** 请求时间戳 */
    private Long timestamp;

    /** 领取记录id */
    private String recordId;

    /**
     * 兑吧订单号
     */
    private String orderNo;

    /** 领取用户id */
    private String custNo;

    /**
     * 1、下单成功；2，卡券充值；3，实物填写收货信息
     */
    private String callBackType;

    /** 领取状态：success；failure */
    private String drawStatus;

    /** 领取失败信息 */
    private String message;

    /** 充值账号 */
    private String account;

    /** 省份 */
    private String province;

    /** 城市 */
    private String city;

    /** 区域 */
    private String area;

    /** 街道 */
    private String street;

    /** 详细地址 */
    private String address;

    /** 姓名 */
    private String name;

    /** 手机号 */
    private String mobile;

}
