package cn.com.duiba.thirdpartyvnew.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 通知类型
 * Created by sunyan on 11/21/17.
 */
public enum NotifyTypeEnum {
    NOTIFY_RESULT(0,"兑换结果通知"),
    NOTIFY_PAY(1,"支付结果通知"),
    NOTIFY_OBJECT_SEND(2, "实物订单发货通知"),
    NOTIFY_POSTSALE(3, "完成售后通知");

    private Integer code;
    private String description;

    NotifyTypeEnum(Integer code, String description){
        this.code=code;
        this.description=description;
    }

    private static Map<Integer,NotifyTypeEnum> NOTIFY_MAP = Maps.newHashMap();
    static {
        for(NotifyTypeEnum notify:NotifyTypeEnum.values()){
            NOTIFY_MAP.put(notify.getCode(),notify);
        }
    }

    public static NotifyTypeEnum getByCode(Integer code) {
        if(code==null){
            //向上兼容
            return NotifyTypeEnum.NOTIFY_RESULT;
        }
        return NOTIFY_MAP.get(code);
    }
    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
